/*******************************************************************************
  ProcessChecker Demo
  Example submitted by David Clegg

  Form used to change details for a monitored or dependant process.
*******************************************************************************/

using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;

namespace ProcessChecker
{
	/// <summary>
	/// Summary description for WinForm.
	/// </summary>
	public class ProcessDetailsForm : System.Windows.Forms.Form
	{
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.TextBox tbProcessName;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.Button btnOK;
		private System.Windows.Forms.OpenFileDialog ofdProcess;
		private System.Windows.Forms.Button btnBrowse;
		private System.Windows.Forms.CheckBox cbCheckResponding;

		public ProcessDetailsForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose (bool disposing)
		{
			if (disposing)
			{
				if (components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose(disposing);
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent() {
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(ProcessDetailsForm));
			this.label1 = new System.Windows.Forms.Label();
			this.tbProcessName = new System.Windows.Forms.TextBox();
			this.btnCancel = new System.Windows.Forms.Button();
			this.btnOK = new System.Windows.Forms.Button();
			this.ofdProcess = new System.Windows.Forms.OpenFileDialog();
			this.btnBrowse = new System.Windows.Forms.Button();
			this.cbCheckResponding = new System.Windows.Forms.CheckBox();
			this.SuspendLayout();
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(8, 24);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(88, 16);
			this.label1.TabIndex = 0;
			this.label1.Text = "Process Name";
			// 
			// tbProcessName
			// 
			this.tbProcessName.Location = new System.Drawing.Point(96, 22);
			this.tbProcessName.Name = "tbProcessName";
			this.tbProcessName.Size = new System.Drawing.Size(192, 20);
			this.tbProcessName.TabIndex = 1;
			this.tbProcessName.Text = "";
			// 
			// btnCancel
			// 
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(256, 72);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 2;
			this.btnCancel.Text = "Cancel";
			// 
			// btnOK
			// 
			this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnOK.Location = new System.Drawing.Point(168, 72);
			this.btnOK.Name = "btnOK";
			this.btnOK.TabIndex = 3;
			this.btnOK.Text = "OK";
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// ofdProcess
			// 
			this.ofdProcess.DefaultExt = "exe";
			this.ofdProcess.Filter = "Executables|*.exe";
			// 
			// btnBrowse
			// 
			this.btnBrowse.Image = ((System.Drawing.Image)(resources.GetObject("btnBrowse.Image")));
			this.btnBrowse.Location = new System.Drawing.Point(288, 22);
			this.btnBrowse.Name = "btnBrowse";
			this.btnBrowse.Size = new System.Drawing.Size(20, 20);
			this.btnBrowse.TabIndex = 4;
			this.btnBrowse.Click += new System.EventHandler(this.btnBrowse_Click);
			// 
			// cbCheckResponding
			// 
			this.cbCheckResponding.Location = new System.Drawing.Point(8, 48);
			this.cbCheckResponding.Name = "cbCheckResponding";
			this.cbCheckResponding.Size = new System.Drawing.Size(128, 24);
			this.cbCheckResponding.TabIndex = 5;
			this.cbCheckResponding.Text = "Check Responding";
			// 
			// ProcessDetailsForm
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(344, 108);
			this.Controls.Add(this.cbCheckResponding);
			this.Controls.Add(this.btnBrowse);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.tbProcessName);
			this.Controls.Add(this.label1);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.Name = "ProcessDetailsForm";
			this.ShowInTaskbar = false;
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
			this.Text = "Process Details";
			this.Load += new System.EventHandler(this.ProcessDetailsForm_Load);
			this.ResumeLayout(false);
		}
		#endregion

		private ProcessDetails fProcess;

		static public DialogResult ShowProcessDetails(ProcessDetails process) {
			ProcessDetailsForm pd = new ProcessDetailsForm();
			pd.fProcess = process;
			return pd.ShowDialog();
		}

		private void PopulateControls() {
			tbProcessName.Text = fProcess.ProcessPath;
			if (fProcess is WatchedProcess) {
				cbCheckResponding.Checked = ((WatchedProcess)fProcess).CheckResponding;
				cbCheckResponding.Visible = true;
			}
			else
				cbCheckResponding.Visible = false;
			((Bitmap)btnBrowse.Image).MakeTransparent();
		}

		private void ProcessDetailsForm_Load(object sender, System.EventArgs e) {
			PopulateControls();
		}

		private void btnOK_Click(object sender, System.EventArgs e) {
			fProcess.ProcessPath = tbProcessName.Text;
			if (fProcess is WatchedProcess)
				((WatchedProcess)fProcess).CheckResponding = cbCheckResponding.Checked;
		}

		private void btnBrowse_Click(object sender, System.EventArgs e) {
			if (ofdProcess.ShowDialog() == DialogResult.OK) {
				tbProcessName.Text = ofdProcess.FileName;
			}
		}
	}
}
